/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ResourceMount;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.metrics.ComputerMBean;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public final class CommonHooks {
    public static final ResourceKey<LootTable> TREASURE_DISK_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"treasure_disk"));
    private static final Set<ResourceKey<LootTable>> TREASURE_DISK_LOOT_TABLES = Set.of(BuiltInLootTables.SIMPLE_DUNGEON, BuiltInLootTables.ABANDONED_MINESHAFT, BuiltInLootTables.STRONGHOLD_CORRIDOR, BuiltInLootTables.STRONGHOLD_CROSSING, BuiltInLootTables.STRONGHOLD_LIBRARY, BuiltInLootTables.DESERT_PYRAMID, BuiltInLootTables.JUNGLE_TEMPLE, BuiltInLootTables.IGLOO_CHEST, BuiltInLootTables.WOODLAND_MANSION, BuiltInLootTables.VILLAGE_CARTOGRAPHER);

    private CommonHooks() {
    }

    public static void onServerTickStart(MinecraftServer server) {
        ServerContext.get(server).tick();
        TickScheduler.tick();
    }

    public static void onServerTickEnd() {
        MonitorWatcher.onTick();
    }

    public static void onServerStarting(MinecraftServer server) {
        if (server instanceof DedicatedServer) {
            DedicatedServer dediServer = (DedicatedServer)server;
            if (dediServer.getProperties().enableJmxMonitoring) {
                ComputerMBean.register();
            }
        }
        CommonHooks.resetState();
        ServerContext.create(server);
        ComputerMBean.start(server);
    }

    public static void onServerStarted(MinecraftServer server) {
        CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)server.getWorldData().enabledFeatures(), (boolean)false, (HolderLookup.Provider)server.registryAccess());
    }

    public static void onServerStopped() {
        CommonHooks.resetState();
    }

    private static void resetState() {
        ServerContext.close();
        NetworkUtils.reset();
    }

    public static void onServerChunkUnload(LevelChunk chunk) {
        if (!(chunk.getLevel() instanceof ServerLevel)) {
            throw new IllegalArgumentException("Not a server chunk.");
        }
        TickScheduler.onChunkUnload(chunk);
    }

    public static void onChunkWatch(LevelChunk chunk, ServerPlayer player) {
        MonitorWatcher.onWatch(chunk, player);
    }

    public static void onChunkTicketLevelChanged(ServerLevel level, long chunkPos, int oldLevel, int newLevel) {
        TickScheduler.onChunkTicketChanged(level, chunkPos, oldLevel, newLevel);
    }

    public static InteractionResult onUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = hitResult.getBlockPos();
        ItemStack heldItem = player.getItemInHand(hand);
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(Blocks.LECTERN) && !((Boolean)blockState.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            return CustomLecternBlock.tryPlaceItem(player, level, pos, blockState, heldItem);
        }
        return InteractionResult.PASS;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LootPool.Builder getExtraLootPool(ResourceKey<LootTable> lootTable) {
        if (!TREASURE_DISK_LOOT_TABLES.contains(lootTable)) {
            return null;
        }
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(TREASURE_DISK_LOOT)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
    }

    public static void onDatapackReload(BiConsumer<String, PreparableReloadListener> addReload) {
        addReload.accept("mounts", (PreparableReloadListener)ResourceMount.RELOAD_LISTENER);
    }

    public static boolean onEntitySpawn(Entity entity) {
        return DropConsumer.onEntitySpawn(entity);
    }

    public static boolean onLivingDrop(Entity entity, ItemStack stack) {
        return DropConsumer.onLivingDrop(entity, stack);
    }

    public static void onBuildCreativeTab(ResourceKey<CreativeModeTab> key, CreativeModeTab.ItemDisplayParameters context, CreativeModeTab.Output out) {
        if (key == CreativeModeTabs.OP_BLOCKS && context.hasPermissions()) {
            out.accept((ItemLike)ModRegistry.Items.COMPUTER_COMMAND.get());
        }
    }
}

